<?php

#============================================================
# URL SHRTN             | URL shortening/forwarding script
#------------------------------------------------------------
# Script provided by Glype Media, http://www.glype.com/
#============================================================

# Start error reporting
error_reporting(E_ALL);
ini_set('display_errors',0);

# Setup base paths
define('PATH',dirname(dirname(__FILE__)).DIRECTORY_SEPARATOR);

# Define default paths
define('INCLUDES',PATH.'includes'.DIRECTORY_SEPARATOR);
define('SKIN',PATH.'skin'.DIRECTORY_SEPARATOR);

# Include configuration
require INCLUDES.'config.php';

# Check its installed
if ( empty($CONFIG) ) {
	$url = 'http'.(empty($_SERVER['HTTPS'])?'':'s').'://'.$_SERVER['HTTP_HOST'].dirname($_SERVER['PHP_SELF']).'/install/';
	$url = basename(dirname($_SERVER['PHP_SELF']))=='admin' ? str_replace('/admin','',$url) : $url;
	header('Location: '.$url);
	exit;
}

# Define variables
$pageTitle = '';

# Start sessions
session_name('s');
session_start();

# Protect sessions
if ( empty($_SESSION['auth']) ) {
	$_SESSION['auth'] = md5($_SERVER['REMOTE_ADDR'].$_SERVER['HTTP_USER_AGENT']);
} else if ( $_SESSION['auth'] != md5($_SERVER['REMOTE_ADDR'].$_SERVER['HTTP_USER_AGENT']) ) {
	if (isset($_COOKIE[session_name()])) {
	    setcookie(session_name(), '', time()-42000, '/');
	}
	$_SESSION = array();
	session_destroy();
	session_start();
}

# Set times
date_default_timezone_set($CONFIG['timezone']);

# Include ad page
include SKIN.'ads.php';

# Check banlist
$blackList = array();
if ( file_exists($file = INCLUDES.'banlist.php') ) {
	include $file;
	if ( in_array(ip2long($_SERVER['REMOTE_ADDR']),$blackList) ) {
		error('You have been banned from this site.');
	}
}

###############################################################
# Global functions
###############################################################

# Connect to database
function connect($CONFIG) {
	//	simple usage required, no need for bloat with abstraction layer
	$conn = mysql_connect($CONFIG['mysqlHost'],$CONFIG['mysqlUser'],$CONFIG['mysqlPass']) or error('Could not connect to database.');
	mysql_select_db($CONFIG['mysqlDb'],$conn) or error('Could not find specified database.');
	return $conn;
}
# Error function
function error($txt) {
	global $pageTitle,$CONFIG;
	include_once SKIN.'top.php';
	echo '
			<h1>Error</h1>
			<p>We could not complete your request. The following error was returned.</p>
			<p style="color:#ffc000;">',$txt,'</p>
			';
	include_once SKIN.'bottom.php';
	exit;
}

# Local redirect
function localRedirect($to='index.php') {
	global $CONFIG;
	header('Location: '.$CONFIG['baseURL'].$to);
	exit;
}

# Clean input
function clean($in) {
	if ( get_magic_quotes_gpc() )
		$in = stripslashes($in);
	return trim($in);
}

# Convert between key and id
function key2id($key) {
	return base_convert($key,36,10);
}
function id2key($id) {
	return base_convert($id,10,36);
}

# Format URLs {
function urlFormat($ins) {
	global $CONFIG;
	return str_replace('[KEY]',$ins,$CONFIG['urlFormat']);
}
?>